# CONTRIBUTE Testimonials

Community made patches, localisation, bug reports and contributions are very welcome and help make Testimonials the #1 testimonials plugin for WordPress.

When contributing please ensure you follow the guidelines below so that we can keep on top of things.

__Please Note:__ GitHub is for bug reports and contributions only - if you have a support question or a request for a customisation don't post here, go to our [Support Forum](http://wordpress.org/support/plugin/testimonials-widget) instead.

For localization, please refer to [How do I change Testimonials text labels?](https://aihrus.zendesk.com/entries/23691557-How-do-I-change-Testimonials-Widget-text-labels-), though bugs with strings that can't be translated are welcome here.

## Getting Started

* Submit a ticket for your issue, assuming one does not already exist.
  * Raise it on our [Issue Tracker](https://github.com/michael-cannon/testimonials-widget/issues)
  * Clearly describe the issue including steps to reproduce the bug.
  * Make sure you fill in the earliest version that you know has the issue as well as the version of WordPress you're using.

## Making Changes

* Fork the repository on GitHub
* Make the changes to your forked repository
  * Ensure you stick to the [WordPress Coding Standards](http://codex.wordpress.org/WordPress_Coding_Standards) and have properly documented any new functions.
* When committing, reference your issue (if present) and include a note about the fix.
* Push the changes to your fork and submit a pull request to the 'master' branch of the Testimonials repository.

## Code Documentation

* Try to ensure that every Testimonials function is documented well and follows the standards set by phpDoc.
* An example function, by Yoast, can be found [here](https://gist.github.com/jdevalk/5574677)
* Please make sure that every function is documented so that when we update our API Documentation things don't go awry!
* Finally, please use tabs and not spaces. The tab indent size should be 4 for all Testimonials code.

At this point you're waiting on us to merge your pull request. We'll review all pull requests, and make suggestions and changes if necessary.


## Additional Resources
* [Testimonials API](https://github.com/michael-cannon/testimonials-widget/blob/master/API.md)
* [General GitHub Documentation](http://help.github.com/)
* [GitHub Pull Request documentation](http://help.github.com/send-pull-requests/)
