<?php
global $iThemesBillboard;
?>
<h4>Widget</h4>
<p>
	<ol>
		<li>Create a new group on the Billboard page for each collection of items.</li>
		<li>Select 'Add Entries' next to the group to items and configure settings.</li>
		<li>Use the Wordpress widget administrator to place the widget in a widget space or sidebar.</li>
	</ol>
	
</p>
<h4>Shortcode</h4>
<p>
	<ul>
		<li>Example shortcode: <b>[it-billboard group="0" title="Title" max='all' entry_order="ordered" new_window="yes"]</b></li>
		<li><b><i>group</i></b> This allows you to chose which Billboard group to display with the shortcode. The group id can be found on the <a href="<?php echo site_url() . '/wp-admin/admin.php?page=ithemes-billboard';?>">settings</a> page.</li>
		<li><b><i>title</i></b> This attribute allows you to place a title above the Billboard group. If you wish to not have a title then do not include this attribute in the shortcode.</li>
		<li><b><i>max</i></b> With the max attribute, you can choose how many images you want to show in the Billboard group. You can enter a number between 1-20 or use "all" for showing all images in the group.</li>
		<li><b><i>entry_order</i></b> This attribute allows to control what order the images will be shown on page load. You can use "ordered", "alphabetical", or "random".</li>
		<li><b><i>new_window</i></b> This will enable the option for image links to be opened in a new window.</li>
	</ul>
	
</p>


<h3>Version History</h3>
<textarea rows="7" cols="65"><?php readfile( $iThemesBillboard->_pluginPath . '/history.txt' ); ?></textarea>
<br /><br />
<script type="text/javascript">
	jQuery(document).ready(function() {
		jQuery("#pluginbuddy_billboard_debugtoggle").click(function() {
			jQuery("#pluginbuddy_billboard_debugtoggle_div").slideToggle();
		});
	});
</script>

<a id="pluginbuddy_billboard_debugtoggle" class="button secondary-button">Debugging Information</a>
<div id="pluginbuddy_billboard_debugtoggle_div" style="display: none;">
	<h3>Debugging Information</h3>
	<?php
	echo '<textarea rows="7" cols="65">';
	echo 'Plugin Version = '.$iThemesBillboard->_name.' '.$iThemesBillboard->_version.' ('.$iThemesBillboard->_var.')'."\n";
	echo 'WordPress Version = '.get_bloginfo("version")."\n";
	echo 'PHP Version = '.phpversion()."\n";
	global $wpdb;
	echo 'DB Version = '.$wpdb->db_version()."\n";
	echo "\n".serialize($iThemesBillboard->_options);
	echo '</textarea>';
	?>
</div>