<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package Genesis\Admin
 * @author  StudioPress
 * @license GPL-2.0+
 * @link    http://my.studiopress.com/themes/genesis/
 */

/**
 * Registers a new admin page, providing content and corresponding menu item for the "What's new" page.
 *
 * @package Genesis\Admin
 *
 * @since 1.9.0
 */
class Genesis_Admin_Upgraded extends Genesis_Admin_Basic {

	/**
	 * Create the page.
	 *
	 * @uses PARENT_THEME_BRANCH      Genesis Framework branch.
	 * @uses \Genesis_Admin::create() Register the admin page.
	 *
	 * @since 1.9.0
	 */
	function __construct() {

		$page_id = 'genesis-upgraded';

		$menu_ops = array(
			'submenu' => array(
				'parent_slug' => 'admin.php',
				'menu_title'  => '',
				'page_title'  => sprintf( __( 'Welcome to Genesis %s', 'genesis' ), PARENT_THEME_BRANCH ),
			)
		);

		$this->create( $page_id, $menu_ops );

		add_action( 'admin_enqueue_scripts', 'add_thickbox' );

	}

	/**
	 * Callback for displaying the What's New admin page.
	 *
	 * @since 1.9.0
	 */
	public function admin() {

		?>
		<div class="wrap about-wrap">

		<img src="<?php echo get_template_directory_uri() . '/lib/admin/images/whats-new.png'; ?>" class="alignright whats-new" />

		<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>

		<div class="about-text"><?php printf( __( 'Congratulations! You\'re now running Genesis %s.', 'genesis' ), PARENT_THEME_BRANCH ); ?></div>

		<div class="changelog">
			<h3><?php _e( 'What&#8217;s New', 'genesis' ); ?></h3>
			<div class="feature-section">

				<h4><?php _e( 'Customizer', 'genesis' ); ?></h4>
				<p><?php _e( 'Many of the settings you would normally find on the theme settings page can now also be found in the customizer. So, you can now adjust things like the layout, breadcrumbs, and the way your content archives, and watch the changes happen in real time.', 'genesis' ); ?></p>

				<h4><?php _e( 'Removing Features', 'genesis' ); ?></h4>
				<p><?php printf( __( 'For users installing Genesis for the first time on a site, we have disabled the "Primary Navigation Extras" setting. If you would like to add custom links like Twitter or RSS, just use a custom menu item and give it a CSS class of <code>right</code> and it will float right. If you wish to display the date or a search form in the navigation menu, <a href="%s" target="_blank">follow this tutorial</a>.', 'genesis' ), 'http://my.studiopress.com/snippets/nav-extras' ); ?></p>

				<h4><?php _e( 'Boring, but important', 'genesis' ); ?></h4>
				<p><?php _e( 'We\'re always improving. Call it a sickness, but we like to make things work really, really well. Here\'s a list of the technical changes in this latest release.', 'genesis' ); ?></p>

				<p>
					<ul>
						<li><?php _e( 'Support Feedblitz as a feed redirection option.', 'genesis' ); ?></li>
						<li><?php _e( 'Prevent unnecessary calls to update server.', 'genesis' ); ?></li>
						<li><?php _e( 'Fixed a breadcrumb compatibility issue with WordPress SEO.', 'genesis' ); ?></li>
						<li><?php _e( 'Fixed IE11 bug in layout selector.', 'genesis' ); ?></li>
						<li><?php _e( 'Added support for RTL in the dashboard for Genesis elements.', 'genesis' ); ?></li>
						<li><?php _e( 'Many other improvements and bug fixes.', 'genesis' ); ?></li>
					</ul>
				<p>

				</div>
		</div>

		<div class="project-leads">

			<h3><?php _e( 'Project Leads', 'genesis' ); ?></h3>

			<ul class="wp-people-group " id="wp-people-group-project-leaders">
			<li class="wp-person">
				<a href="http://twitter.com/nathanrice"><img src="//0.gravatar.com/avatar/fdbd4b13e3bcccb8b48cc18f846efb7f?s=120" class="gravatar" alt="Nathan Rice" /></a>
				<a class="web" href="http://twitter.com/nathanrice">Nathan Rice</a>
				<span class="title"><?php _e( 'Lead Developer', 'genesis' ); ?></span>
			</li>
			<li class="wp-person">
				<a href="http://twitter.com/sillygrampy"><img src="//0.gravatar.com/avatar/7b8ff059b9a4504dfbaebd4dd190466e?s=120" class="gravatar" alt="Ron Rennick" /></a>
				<a class="web" href="http://twitter.com/sillygrampy">Ron Rennick</a>
				<span class="title"><?php _e( 'Lead Developer', 'genesis' ); ?></span>
			</li>
			<li class="wp-person">
				<a href="http://twitter.com/bgardner"><img src="//0.gravatar.com/avatar/c845c86ebe395cea0d21c03bc4a93957?s=120" class="gravatar" alt="Brian Gardner" /></a>
				<a class="web" href="http://twitter.com/bgardner">Brian Gardner</a>
				<span class="title"><?php _e( 'Lead Developer', 'genesis' ); ?></span>
			</li>
			</ul>

		</div>

		<div class="contributors">

			<h3><?php _e( 'Contributors', 'genesis' ); ?></h3>

			<ul class="wp-people-group" id="wp-people-group-contributing-developers">
			<?php
			$contributors = genesis_contributors();

			shuffle( $contributors );

			foreach ( $contributors as $contributor ) {
				echo '<li class="wp-person">';
				printf( '<a href="%s"><img src="%s" alt="%s" class="gravatar" /></a><a class="web" href="%s">%s</a>', esc_url( $contributor['url'] ), esc_url( $contributor['gravatar'] ), esc_attr( $contributor['name'] ), esc_url( $contributor['url'] ), esc_html( $contributor['name'] ) );
				printf( '<span class="title">%s</span>', __( 'Contributor', 'genesis' ) );
				echo '</li>' . "\n";
			}
			?>
			</ul>

		</div>

		<div class="return-to-dashboard">
			<p><a href="<?php echo esc_url( menu_page_url( 'genesis', 0 ) ); ?>"><?php _e( 'Go to Theme Settings &rarr;', 'genesis' ); ?></a></p>
			<p><a href="<?php echo esc_url( menu_page_url( 'seo-settings', 0 ) ); ?>"><?php _e( 'Go to SEO Settings &rarr;', 'genesis' ); ?></a></p>
		</div>

		</div>
		<?php

	}

}
